<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    version="1.0">
    <xsl:template match="TEI">
        <html>
            <teiHeader></teiHeader>
    <body> 
    <p>



        <h3>All lines spoken by Lord Darlington</h3>
        <ul>            
            <xsl:apply-templates select="//sp[ speaker = 'LORD DARLINGTON' ]" />
        </ul>
        
        <h3>Lines in which Lord Windermere speaks of Mrs Erlynne</h3>
        <ul>            
            <xsl:apply-templates select="//sp[ contains( p , 'Erlynne' ) ]" />
        </ul>
        
        
        <h3>Stage directions indicating the entrance of a character on the stage.</h3>
        <ul>            
            <xsl:apply-templates select="//stage[ @type = 'entrance' ]" />
        </ul>
        
        <h3>Lines spoken by Lady Windermere which consist of less than 50 characters</h3>
        <ul>            
            <xsl:apply-templates select="//sp[ speaker = 'LADY WINDERMERE' and string-length( p ) &lt; 50 ]" />
        </ul>
        
    
        
     
        
        
        <h3>The number of parts spoken by Lady Windermere</h3>
            <xsl:value-of select="count( //sp[ speaker = 'LADY WINDERMERE' ] )"/>
     
        <h3>The number of parts spoken by Lady Windermere in the first act</h3>
        <xsl:value-of select="count( //div1[ @n = 1 ]/sp[ speaker = 'LADY WINDERMERE' ] )"/>
     
        


    </p>
    </body>
    </html>
    </xsl:template>
    
    
    <xsl:template match="sp">
        
        <li>
            <xsl:value-of select="speaker"/>
            <xsl:text>: </xsl:text>                                  
            <xsl:value-of select="p"/>
            
            
        </li>
        
    </xsl:template>
    
    <xsl:template match="stage">
        
        <li>
                                     
            <xsl:value-of select="."/>
            
            
        </li>
        
    </xsl:template>
    
    
</xsl:stylesheet>

